IF OBJECT_ID('EST_PROD_PRECO_PESQ_MERC_PROPRIO') IS NULL 
BEGIN
CREATE TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO](
	[CD_EMP] [int] NOT NULL,
	[CD_PESQ] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[VLR_CUSTO] [money] NOT NULL,
	[VLR_OFERTA] [money] NOT NULL,
	[VLR_TABELA] [money] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[QTDE_MEDIAF] [money] NULL,
 CONSTRAINT [PK_EST_PROD_PRECO_PESQ_MERC_PROPRIO] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_PESQ] ASC,
	[CD_FILIAL] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 85) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_CD_PESQ]  DEFAULT ((0)) FOR [CD_PESQ]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_CD_CONCOR]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_VLR_OFERTA]  DEFAULT ((0)) FOR [VLR_OFERTA]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_VLR_TABELA]  DEFAULT ((0)) FOR [VLR_TABELA]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_CD_USU]  DEFAULT ((1)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] ADD  CONSTRAINT [DF_EST_PROD_PRECO_PESQ_MERC_PROPRIO_QTDE_MEDIAF]  DEFAULT ((0)) FOR [QTDE_MEDIAF]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] CHECK CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_EST_PROD]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FILIAL])
REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] CHECK CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_PRC_FILIAL]

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_PROPRIO_EST_PROD_PRECO_PESQ] FOREIGN KEY([CD_EMP], [CD_PESQ])
REFERENCES [dbo].[EST_PROD_PRECO_PESQ_MERC] ([CD_EMP], [CD_PESQ])

ALTER TABLE [dbo].[EST_PROD_PRECO_PESQ_MERC_PROPRIO] CHECK CONSTRAINT [FK_EST_PROD_PRECO_PESQ_MERC_PROPRIO_EST_PROD_PRECO_PESQ]
end